function [ c, rms ] = lsqspl(d,n,delta,t,z)
%Find least squares fit in S^r_d(\Delta) to given data.
%   d is degree of polys in S^r_d. delta is the extended knot sequence.  n
%   is the dim of S^r_d(\Delta). t and z are column vectors.  t gives the
%   x-coordinates of the data points to be fit and z is the y-coordinates.

numpt = size(t,1);
%Compute the value of normalized b-splines at all data points
N = zeros(numpt,n); %N = (N_1(\vec{t}) ... N_n(\vec{t}))
Identity = eye(n);
for j=1:n
    N(:,j) = sval2(d,delta,n,Identity(:,j)',t);
end

%Principal Matrix for least-squares
G = N'*N; %Schumaker 1.8 (1.46)

%Forcing term for equation
g = zeros(n,1);
for i=1:n
    g(i,1) = sum(z.*N(:,i));
end

c = rref([G g]);
c = c(:,n+1)';

%Compute rms error
y_val = sval2(d,delta,n,c,t);
rms = sqrt(1/numpt*sum(...
                        (y_val-z).^2 ...
                      ));
end

